// Modules to control application life and create native browser window
const electron = require('electron');
const { app, Menu, Tray } = electron;
const { BrowserWindow } = electron;
const path = require('path');
const ipc = require('electron').ipcMain;
const {shell} = require('electron')

// Keep a global reference of the window object, if you don't, the window will
// be closed automatically when the JavaScript object is garbage collected.
let mainWindow
let newWindow
let timer = null

function createWindow () {
  const electronScreen = require('electron').screen
  const size = electronScreen.getPrimaryDisplay().size
  // Create the browser window.
  mainWindow = new BrowserWindow({width: 700, height: 500, frame: false, resizable: false})

  // and load the index.html of the app.
  mainWindow.loadFile('index.html')

  // Open the DevTools.
  // mainWindow.webContents.openDevTools()

  // Emitted when the window is closed.
  mainWindow.on('closed', function () {
    // Dereference the window object, usually you would store windows
    // in an array if your app supports multi windows, this is the time
    // when you should delete the corresponding element.
    mainWindow = null
  })
  
  mainWindow.setMenu(null)
}

// This method will be called when Electron has finished
// initialization and is ready to create browser windows.
// Some APIs can only be used after this event occurs.
app.on('ready', createWindow)

// Quit when all windows are closed.
app.on('window-all-closed', function () {
  // On macOS it is common for applications and their menu bar
  // to stay active until the user quits explicitly with Cmd + Q
  if (process.platform !== 'darwin') {
    app.quit()
  }
})

app.commandLine.appendSwitch('autoplay-policy', 'no-user-gesture-required');

app.on('activate', function () {
  // On macOS it's common to re-create a window in the app when the
  // dock icon is clicked and there are no other windows open.
  if (mainWindow === null) {
    createWindow()
  }
})

ipc.on('news', function() {
  if(newWindow.isVisible()) {

    newWindow.showInactive()
    newWindow.flashFrame(true)
  }else {

    newWindow.hide()

    let count = 0
    timer = setInterval(function() {
        count++;
        if (count % 2 == 0) {
          tray.setImage(path.join(__dirname, 'icon.ico'))
        } else {
          tray.setImage(path.join(__dirname, 'icon2.png'))
        }
    }, 600)
	
  }
})

ipc.on('close', function() {
  mainWindow.close()
})

ipc.on('close-new-chat', function(event) {
  newWindow.destroy()
})

ipc.on('close-chat', function(event) {
  newWindow.hide(); 
  newWindow.setSkipTaskbar(true);
  event.preventDefault();
})

ipc.on('min', function() {
  newWindow.minimize()
})

ipc.on('login', function() {
	
  const electronScreen = require('electron').screen
  const size = electronScreen.getPrimaryDisplay().size
  // Create the browser window.
  newWindow = new BrowserWindow({
    frame: false, 
    resizable: false
  })

  newWindow.maximize();

  // and load the index.html of the app.
  newWindow.loadFile('service.html')

  // Open the DevTools.
  // newWindow.webContents.openDevTools()

  // Emitted when the window is closed.
  newWindow.on('closed', function () {
    // Dereference the window object, usually you would store windows
    // in an array if your app supports multi windows, this is the time
    // when you should delete the corresponding element.
    newWindow = null
  })
  
  tray = new Tray(path.join(__dirname, 'icon.ico'));
  
  newWindow.on('show', () => {
    tray.setHighlightMode('always')
  })
  
  newWindow.on('hide', () => {
    tray.setHighlightMode('never')
  })

  const contextMenu = Menu.buildFromTemplate([
    {label: '退出', click: () => {newWindow.destroy()}},
  ])
  
  tray.setToolTip('whisper客服')
  tray.setContextMenu(contextMenu)
  tray.on('click', ()=> {
	  
	  tray.setImage(path.join(__dirname, 'icon.ico'))
    clearInterval(timer)
    newWindow.isVisible() ? newWindow.hide() : newWindow.show()
    newWindow.isVisible() ? newWindow.setSkipTaskbar(false) : newWindow.setSkipTaskbar(true)
  })
  
  newWindow.setMenu(null)
  mainWindow.destroy()
})

ipc.on('loginOut', function() {
  createWindow();
  newWindow.destroy();
})

// In this file you can include the rest of your app's specific main process
// code. You can also put them in separate files and require them here.
